% ex5_61.m
% (S1) tanh + (x+cx*x), p.100
% EKF-IEKF 
clear
N=100;
r=1;
q=4;
b=1;
c=-0.1;
kk=100;
t=0:1:N;
% randn('state',0);
varf=zeros(1,kk);
varp=zeros(1,kk);
L=3
for k=1:kk
x=zeros(1,N+1);
v=sqrt(r)*randn(1,N+1);
w=sqrt(q)*randn(1,N+1);
y=zeros(1,N+1);
u=zeros(1,N+1);
u=sin(2*pi*t/50);
x(1)=0;
% data generation
for i=1:N
x(i+1)= tanh(x(i)) + b*u(i)+w(i);
y(i)=x(i) + c*x(i)*x(i) + v(i);
end
%
% Iterated Extended Kalman filter
xep=zeros(1,N+1);  % prediction xe_{t/t-1}
xef=zeros(1,N+1);  % filtering  xe_{t/t}
Pep=zeros(1,N+1);  % covariance of prediction P_{t/t-1}
Pef=zeros(1,N+1);  % covariance of filtering P_{t/t}
Pep(1,1)=5;        % initial covariance of prediction
K=zeros(1,L);
for i=1:N+1
    eta0=xep(1,i);
    for j=1:L
H=1+2*c*eta0;
K(1,j)=Pep(1,i)*H/(H*Pep(1,i)*H+r);       % Kalman gain
    eta1=xep(1,i) + K(1,j)*(y(i)-eta0-c*eta0*eta0-H*(xep(1,i)-eta0)); 
    eta0=eta1;
    end
    xef(1,i)=eta1;
Pef(1,i)=r*Pep(1,i)/(H*Pep(1,i)*H+r);  % covariance of filtering
F=1/cosh(xef(1,i));
F=F*F;
Pep(1,i+1)=F*Pef(1,i)*F' + q;   % covarinace of prediction
xep(1,i+1)=tanh(xef(1,i))+b*u(1,i);    % predicted estimate
end

xep=xep(1,1:N+1);
Pep=Pep(1,1:N+1);
ef=xef-x;
ep=xep-x;
varf(k)=var(ef);  % filtering error 
varp(k)=var(ep);  % prediction error
end
vvarf=mean(varf)
vvarp=mean(varp)

figure(1)
plot(t,x(1,1:N+1),'r',t,y(1,1:N+1),'gx-',t,xef(1,1:N+1),'bo-',...
    'LineWidth',1.3)
xlabel('Number of steps t')
title('Fig 5.3a: Filtering')
axis([0,100,-6,8]);
grid
legend('True x_t','Observation y_t','Filtered estimate x_{t|t}')

figure(2)
plot(t,Pef(1,1:N+1),'b-',t,Pep(1,1:N+1),'m-','LineWidth',1.5)
xlabel('Number of steps t')
title('Fig. 5.3b: Variances of Filtering and Prediction')
axis([0,100,0,8]);
grid
legend('Filtering P_{t|t}',...
    'Prediction P_{t|t-1}')


